/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.security.item;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemStackOwnerObject
extends ItemCapabilityWrapper.ItemCapability
implements IOwnerObject {
    @Override
    @Nullable
    public UUID getOwnerUUID() {
        ItemStack stack = this.getStack();
        return stack.m_41619_() ? null : ItemDataUtils.getUniqueID(stack, "owner");
    }

    @Override
    @Nullable
    public String getOwnerName() {
        UUID owner = this.getOwnerUUID();
        if (owner != null) {
            return OwnerDisplay.getOwnerName(MekanismUtils.tryGetClientPlayer(), owner, null);
        }
        return null;
    }

    @Override
    public void setOwnerUUID(@Nullable UUID owner) {
        ItemStack stack = this.getStack();
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (item instanceof IFrequencyItem) {
                IFrequencyItem frequencyItem = (IFrequencyItem)item;
                frequencyItem.setFrequency(stack, null);
            }
            ItemDataUtils.setUUID(stack, "owner", owner);
        }
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(BasicCapabilityResolver.constant(Capabilities.OWNER_OBJECT, this));
    }
}

